//---------------------------------------------------------------------------
#ifndef audiocH
#define audiocH
typedef struct
{
  // RIFF Header
  char RIFF[4];                  // 'RIFF'
  unsigned long FileLength;      // FileLenth -8 (bytes)
  char FormatType[4];            // 'WAVE'
  // Chunk Header
  char ChunkType[4];             // 'fmt '
  unsigned long ChunkLength;     // length of the fmt data
  // Format header
  short FormatTag;               // 1=PCM, >1 compressed
  short Channels;                // 1=mono 2=stereo
  unsigned long SampleRate;      // Samples per second
  unsigned long BytesPerSec;     // SampleRate*BlockAlign
  short BlockAlign;              // Channels*BitsPerSample / 8
  short BitsPerSample;           // 8 or 16
  // Data Header
  char DATA[4];                  // 'data'
  unsigned long DataLength;      // Length of the Data Block In Bytes
  // Data Follows
}  WaveHeaderStruct;


class AudioC
{
public:

AudioC(char *fname);         //constructor w/auto create from file
AudioC();			         //default contstructor w/ blank object
AudioC(AudioC&);			 //copy constructor
~AudioC();                   // destructor
long ReadFile(char *fname);  // read a file in
long WriteFile(char *fname); // save file
// return current sample rate
long GetSampleRate()	   {return(Hdr.SampleRate);};
// return pointer to current buffer
char *GetBuffer()		   {return(Buf);};
// return the number of channels (1=mono 2=stereo)
short GetNumChan()		   {return(Hdr.Channels);};
// return Bits/Sample (8 or 16)
short GetBitsPerSamp()	   {return(Hdr.BitsPerSample);};
// return the number of samples in the buffer
unsigned long GetNumSamps(){return(Hdr.DataLength*8/Hdr.BitsPerSample);};
// return the number of bytes in the buffer
unsigned long GetNumBytes(){return(0);};
// set the Sample Rate;
unsigned long SetSampleRate(unsigned long SampleRate);
// copy user buffer to object
char *SetBuffer(char *NewBuf,unsigned long NewNumBytes);
// set the number of channels (1=mono,2=stereo)
short SetNumChan(short NumChan);
// set the Number of BitsPerSample (8 or 16)
short SetBitsPerSamp(short BitsPerSamp);
// set the number of samples in the buffer
unsigned long SetNumSamps(unsigned long NumSamps);

protected:
  WaveHeaderStruct Hdr;
  char *Buf;
  unsigned long MaxBytes;
  unsigned long NumSamps;
private:
  void init();

};


//---------------------------------------------------------------------------
#endif
